//
//  MCEventTracker+SyncEventsSupport.h
//  MCServerSupport
//
//  Created by Brent Gulanowski on 21/11/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//


#import <MCServerSupport/MCEventTracker.h>

#import <MCServerSupport/MCTrackedEvent.h>


@interface MCEventTracker (SyncEventsSupport)

// in the following three messages, aType, aDate and aClient arguments are mandatory
- (MCSyncEvent *)recordSyncEventWithType:(MCEventType)aType date:(NSDate *)aDate client:(MCTrackedClient *)aClient message:(NSString *)aMessage;
- (MCSyncEvent *)recordSyncEventWithType:(MCEventType)aType date:(NSDate *)aDate client:(MCTrackedClient *)aClient changes:(NSArray *)changeRecords;
- (MCSyncEvent *)recordSyncEventWithType:(MCEventType)aType date:(NSDate *)aDate client:(MCTrackedClient *)aClient;

// in the following four methods, aClient can be nil as long as currentClient is set
- (MCSyncEvent *)recordInitEventForClient:(MCTrackedClient *)aClient;
- (MCSyncEvent *)recordSyncUpEventForClient:(MCTrackedClient *)aClient withChanges:(NSArray *)changeRecords;
- (MCSyncEvent *)recordSyncDownEventForClient:(MCTrackedClient *)aClient withChanges:(NSArray *)changeRecords;
- (MCSyncEvent *)recordErrorForClient:(MCTrackedClient *)aClient message:(NSString *)errMsg;
- (MCSyncEvent *)recordClientError:(NSString *)errMsg;

@end
